/***************************************************************************
 *
 * Copyright 2010,2011 BMW Car IT GmbH
 * Copyright (C) 2012 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/
#include "SetDisplayGammaCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"

SetDisplayGammaCommand::~SetDisplayGammaCommand()
{
}

ExecutionResult SetDisplayGammaCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());
    ExecutionResult result = ExecutionFailed;
    //check if screen exist
    if (!scene.getScreen(m_screenID))
        return ExecutionFailed;


    LOG_INFO("SetDisplayGammaCommand", "on screen=" << m_screenID<<" gamma value: "<<m_gamma);

    IRenderer* renderer = *((executor->getRendererList())->begin());
    if (renderer)
    {
        renderer->setGamma(m_screenID,m_gamma);
        result = ExecutionSuccessRedraw;
    }
    else
        return ExecutionFailed;

    return result;
}

const std::string SetDisplayGammaCommand::getString()
{
    std::stringstream description;
    description << "SetDisplayGammaCommand("
                << "m_screenID=" << m_screenID << ",gamma=" << m_gamma << ")" ;

    return description.str();
}
